function solve
% solve the equations

global ngj Dj delay_jj NUM_FLOWS k gamma_ah gamma_ie gamma_ae g gmin gmax Sint imax g1m_store period_store amp_store j1max tspan dmin dmax dstep ng;
global aiiA_store AHL_store AHLe_store luxI_store;
global cp g1m;
global AD1;
clear peak_difs peak_values;

tspace=0.1; %timestep
tspan = [0:tspace:250];

%%THESE ARE PARAMETERS TO POSSIBLY LOOP OVER

%Dj=[0.5]; %diffusion Dj=[0.5 1.0];

%delay_jj=[1.0];  %delay

%ngj=[1.5]*1.0;  %cell density
if ~get(AD1.C3, 'value')
    ngj = [dmin:dstep:dmax];
    j1max=length(ngj);  %PARAMETER TO LOOP OVER
else
    j1max=1;
end

for jj=1:j1max % vary different cell density
    if  cp ==2
        break;
    end
 ng=ngj(jj);
 c1=1.0*ng;  gj=[0.012]*c1; gamma_ahjj=[0.15]*c1;
 c2=1.0*ng;  fj=[0.3]*c2; gamma_aejj=[150.0]*c2; gamma_iejj=[gamma_aejj*1.25]*c2;
 c3=1.0*ng;  bj=[0.5]*c3; kj=[1.0]*c3;
 c4=1.0*ng;  alphaj=[2500.0]*c4;  k1_jj=[0.0]*c4;      % parameters ......><  are wrong?
 
 
 %copy #'s of aiiA luxI
 c_a=10;  c_i=40;

 %diffusion, alpha
 D=Dj(1);
 alpha=alphaj(1); k1=k1_jj(1);

 %parameters for 3 eqn model
 delay=delay_jj(1); 

 %enzymatic AHL decay
 %gamma_ah=gamma_ahjj(1); g=gj(1);

 %enzymatic aiiA decay and luxI decay
 %gamma_ae=gamma_aejj(1); 
 f=fj(1);  
 %gamma_ie=gamma_iejj(1); 
      
 %gamma_a decay, exponential
 gamma_a=0.0; gamma_i=gamma_a;

 %luxI production
 b=bj(1); 
 %k=kj(1);

 %AHL decay rate, internal
 gamma_h=0.0;

 
 %FLOW RATE RANGE , gamma_he
 
 %gmin=0.00; gmax=3.0; 
 %NUM_FLOWS=5;
 if ~(get(AD1.C2, 'value'))
    g1m=[0 gmin:NUM_FLOWS:gmax];
    if g1m(2)==0
        g1m(1)=[];
    end
    imax=length(g1m);
 else
    imax = 1;
    g1m(1) = g;
 end

for i=1:imax
    gamma_He=g1m(i);
    
clear peak_difs peak_values;
IC(1) = 0;          % aiiA
IC(2) = 0;          % AHL internal
IC(3) = 0;          % AHL external
IC(4) = 0;          % luxI

parameters=[alpha,gamma_ae,gamma_a,gamma_ah,gamma_h,f,g,b,0,k,0,c_a,D,gamma_He,k1,gamma_i,c_i,gamma_ie];
options = ddeset('AbsTol', 1e-4);

sol = dde23(@synchnegpos_4eqns_diffusion_luxI, [delay], IC, tspan, options, parameters);% options);
Sint = deval(sol,tspan);

        if cp == 2
            break;
        end

        MOL=4; %luxI

peak_difs=zeros(1,3);
amps=zeros(1,3);
amp_ratio=zeros(1,3);

%FIND LOCAL MAXS
peak_values=localMaximum(Sint(MOL,:),30);

%%THEN FIND DIFS OF LOCAL_MAXS
for j=1:length(peak_values)-1
    peak_difs(j)=peak_values(j+1)-peak_values(j);
end

%peak_difs=peak_difs %*tspace
% % max LUXI = max aiiA?
maxs=Sint(1,peak_values);

valley_values=localMaximum(-Sint(MOL,:),30); %awesome

mins=Sint(1,valley_values);
% the subtraction of peak and valley values
for j=4:min(length(peak_values),length(valley_values))-1
    amps(j)=maxs(j)-mins(j);
end

%amps;
% the ratio of amplify, is 4 the right number?
period_dist=4;
for j=4:length(amps)-period_dist
    amp_ratio(j)=amps(j+period_dist)/amps(j);
end
    
 
%  if (i==1)
%     figure(1);
%     subplot(4,1,1); cla;
%     subplot(4,1,2); cla;
%     subplot(4,1,3); cla;
%     subplot(4,1,4); cla;
%     
%     figure(4);
%     subplot(4,1,1); cla;
%     subplot(4,1,2); cla;
%     subplot(4,1,3); cla;
%     subplot(4,1,4); cla;
% end  
 
%   figure(1);
%   subplot(4,1,1); plot(tspan, Sint(1,:), '-','Color',[i/imax*250/255 i/imax*250/255 i/imax*20/255]);ylabel('aiiA'); hold on;   %in the [] are three numbers no bigger than 1, control the color 
%   subplot(4,1,2); plot(tspan, Sint(2,:), '-','MarkerSize',5,'Color',[i/imax*250/255 i/imax*250/255 i/imax*25.5/255]);ylabel('AHL internal'); hold on;
%   subplot(4,1,3); plot(tspan, Sint(3,:), '-','MarkerSize',5,'Color',[i/imax*250/255 i/imax*250/255 i/imax*25.5/255]);ylabel('AHL external'); hold on;
%   subplot(4,1,4); plot(tspan, Sint(4,:), '-','MarkerSize',5,'Color',[i/imax*250/255 i/imax*250/255 i/imax*25.5/255]);ylabel('luxI'); hold on;

  
  %FIND PERIODS
  m=mean(peak_difs);
  am=mean(amps);
  am_ratio=mean(amp_ratio(4:end));
%   if (am>5 & (am_ratio<1.05 & am_ratio>0.95))
     amp(i)=am; period(i)=m;
%   else
%      amp(i)=0; period(i)=0;
%   end

      
  %STORE VARIABLES
   aiiA_store(i,:, jj)=Sint(1,:);
   AHL_store(i,:, jj)=Sint(2,:);
   AHLe_store(i,:, jj)=Sint(3,:);
   luxI_store(i,:, jj)=Sint(4,:);
  

  %period
  %amp;
    
  %PLOT PERIODS, AMPLITUDES
%   figure(2); subplot(2,1,1); plot(g1m,period,'x-');  legend('period');title('period v. flow rate');
%   subplot(2,1,2); plot(g1m,amp,'o-');
%   legend('amplitude');

  %STORE FLOW RATES, PERIODS, AMPLITUDES
  g1m_store(jj, i)=g1m(i);
  period_store(jj, i)=mean(period);
  amp_store(jj, i)=mean(amp);
end
    if cp == 2
        break;
    end
end

if cp ~= 2
    cp = 1;
    set(Note, 'windowstyle', 'normal');
    delete(Note);
end


% %PLOT PERIODS and AMPLITUDE vs. LOOPED PARAMETER
% for j1=1:j1max
%     if (j1==1)
%      figure(3); subplot(2,1,1); cla;
%      figure(3); subplot(2,1,2); cla;
%     end
%   figure(3); subplot(2,1,1); plot(g1m_store(j1,:),period_store(j1,:),'x-','Color',[j1/j1max*20/255 j1/j1max*250/255 j1/j1max*20/255]); hold on;
%              subplot(2,1,2); plot(g1m_store(j1,:),amp_store(j1,:),'x-','Color',[j1/j1max*20/255 j1/j1max*250/255 j1/j1max*20/255]); hold on;
%              title('period vs. flow rate looped parameter');
% end
end